(function() {

    const root = document.documentElement;

    function toggleDarkMode() {
        const currentTheme = root.getAttribute("data-theme");
        const newTheme = currentTheme === "dark" ? "light" : "dark";
        root.setAttribute("data-theme", newTheme);
        localStorage.setItem("theme", newTheme);
        images = document.getElementsByClassName("imageDarkLight");
        Array.prototype.forEach.call(images, function(el) {
            // Do stuff here
            el.src = el.getAttribute("src-" + newTheme);
            console.log(el.getAttribute("src-" + newTheme));
        });
    }

    function init() {
        const storedPreference = localStorage.getItem("theme");
        const systemPrefersDark = window.matchMedia("(prefers-color-scheme: dark)").matches;
        const theme = storedPreference || (systemPrefersDark ? "dark" : "light");
        root.setAttribute("data-theme", theme);

    }

    init();

    document.addEventListener("DOMContentLoaded", function() {
        const togglers = document.querySelectorAll("[data-theme-toggler]");
        togglers.forEach((toggler) => {
            toggler.addEventListener("click", toggleDarkMode);
        });
    });

})();